//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Environment.h"
#include "inifiles.hpp"

#pragma package(smart_init)

TCommParameter CommParameter[MAX_COMM_COUNT];
TApplicationStartOption ApplicationStartOption;
TProgramPath ProgramPath;

//---------------------------------------------------------------------------
void __fastcall Environment_Init(void)
{
}
//---------------------------------------------------------------------------
void __fastcall Environment_Destroy(void)
{
}
//---------------------------------------------------------------------------
void __fastcall ReadCommunicationParams(AnsiString fileName)
{
  TIniFile *iniFile = new TIniFile(fileName);
  if (iniFile)
  {
    for(int commIndex = 0; commIndex < MAX_COMM_COUNT; commIndex++)
    {
      if(commIndex == COMM_HCB)
      {
        CommParameter[commIndex].TcpPort = iniFile->ReadInteger("Tcp/Ip Params", "Comm Port " + IntToStr(commIndex + 1), 1002);
        strcpy(CommParameter[commIndex].IpAddress, iniFile->ReadString("Tcp/Ip Params", "Ip Adddress " + IntToStr(commIndex + 1), "192.168.0.60").c_str());
      }
      else if(commIndex == COMM_TPB)
      {
        CommParameter[commIndex].TcpPort = iniFile->ReadInteger("Tcp/Ip Params", "Comm Port " + IntToStr(commIndex + 1), 1002);
        strcpy(CommParameter[commIndex].IpAddress, iniFile->ReadString("Tcp/Ip Params", "Ip Adddress " + IntToStr(commIndex + 1), "192.168.0.70").c_str());
      }
      else
      {
        int tempAddress;
        tempAddress = 50 + commIndex;

        CommParameter[commIndex].TcpPort = iniFile->ReadInteger("Tcp/Ip Params", "Comm Port " + IntToStr(commIndex + 1), 1002);
        strcpy(CommParameter[commIndex].IpAddress, iniFile->ReadString("Tcp/Ip Params", "Ip Adddress " + IntToStr(commIndex + 1), "192.168.0." + IntToStr(tempAddress)).c_str());
      }      
    }
  }
  delete iniFile;
}

//---------------------------------------------------------------------------
void __fastcall WriteDefaultCommunicationParams(AnsiString fileName)
{
  TIniFile *iniFile = new TIniFile(fileName);
  if (iniFile)
  {
    for(int commIndex = 0; commIndex < MAX_COMM_COUNT; commIndex++)
    {
      if(commIndex == COMM_HCB)
      {
        iniFile->WriteInteger("Tcp/Ip Params", "Comm Port " + IntToStr(commIndex + 1), 1002);
        iniFile->WriteString("Tcp/Ip Params", "Ip Adddress " + IntToStr(commIndex + 1), "192.168.0.60");
      }
      else if(commIndex == COMM_TPB)
      {
        int tempAddress;
        tempAddress = 70;

        iniFile->WriteInteger("Tcp/Ip Params", "Comm Port " + IntToStr(commIndex + 1), 1002);
        iniFile->WriteString("Tcp/Ip Params", "Ip Adddress " + IntToStr(commIndex + 1), "192.168.0." + IntToStr(tempAddress));
      }
      else
      {
        int tempAddress;
        tempAddress = 50 + commIndex;

        iniFile->WriteInteger("Tcp/Ip Params", "Comm Port " + IntToStr(commIndex + 1), 1002);
        iniFile->WriteString("Tcp/Ip Params", "Ip Adddress " + IntToStr(commIndex + 1), "192.168.0." + IntToStr(tempAddress));
      }
    }
  }
  delete iniFile;
}

//---------------------------------------------------------------------------
void __fastcall ReadApplicationOption(AnsiString fileName, TApplicationStartOption *pApplicationStartOption)
{
  TIniFile *iniFile = new TIniFile(fileName);
  if (iniFile)
  {
    pApplicationStartOption->SelectedLCID 				= iniFile->ReadInteger("System Info", "Language ID", SYSTEM_INFO_LCID_KR);
    pApplicationStartOption->SelectedCommType 		= iniFile->ReadInteger("System Info", "Communication Type", SYSTEM_INFO_COMM_TYPE_TCP_IP);
    pApplicationStartOption->MachineType 					= iniFile->ReadInteger("System Info", "MachineType", SYSTEM_INFO_MACHINE_TYPE_200H);
    pApplicationStartOption->comm_brdCount 				= iniFile->ReadInteger("System Info", "IPB Count", SYSTEM_INFO_DEFAULT_BRD_COUNT);
    pApplicationStartOption->LaserComplexer 			= iniFile->ReadInteger("System Info", "Is Laser Complexer", 0);
    pApplicationStartOption->CommCheckSW 					= iniFile->ReadInteger("System Info", "Communication Check", 1);
    pApplicationStartOption->noLicenseApplication = iniFile->ReadInteger("System Info", "No License", 0);
    pApplicationStartOption->tmsAppName 					= iniFile->ReadString("System Info", "Tablet File Name", "TVM_Application");
    pApplicationStartOption->cmsAppName 					= iniFile->ReadString("System Info", "Capsule File Name", "CVM_Application");
    pApplicationStartOption->sLaserPath 					= iniFile->ReadString("System Info", "sLaser Path", "");
    pApplicationStartOption->TPB_OperationMode		= iniFile->ReadInteger("System Info", "TPB_OperationMode", 0);
  }
  delete iniFile;
}

//---------------------------------------------------------------------------
void __fastcall WriteApplicationOption(AnsiString fileName, TApplicationStartOption *pApplicationStartOption)
{
  TIniFile *iniFile = new TIniFile(fileName);
  if (iniFile)
  {
    iniFile->WriteInteger("System Info", "Language ID", pApplicationStartOption->SelectedLCID);
    iniFile->WriteInteger("System Info", "Communication Type", pApplicationStartOption->SelectedCommType);
    iniFile->WriteInteger("System Info", "MachineType", pApplicationStartOption->MachineType);
    iniFile->WriteInteger("System Info", "IPB Count", pApplicationStartOption->comm_brdCount);
    iniFile->WriteInteger("System Info", "Is Laser Complexer", pApplicationStartOption->LaserComplexer);
    iniFile->WriteInteger("System Info", "Communication Check", pApplicationStartOption->CommCheckSW);
    iniFile->WriteInteger("System Info", "No License", pApplicationStartOption->noLicenseApplication);
    iniFile->WriteString("System Info", "Tablet File Name", pApplicationStartOption->tmsAppName);
    iniFile->WriteString("System Info", "Capsule File Name", pApplicationStartOption->cmsAppName);
    iniFile->WriteString("System Info", "sLaser Path", pApplicationStartOption->sLaserPath);
    iniFile->WriteInteger("System Info", "TPB_OperationMode", pApplicationStartOption->TPB_OperationMode);
  }
  delete iniFile;
}
//---------------------------------------------------------------------------
void __fastcall TPB_WriteApplicationOption(AnsiString fileName, TApplicationStartOption *pApplicationStartOption)
{
  TIniFile *iniFile = new TIniFile(fileName);
  if (iniFile)
  {
    iniFile->WriteInteger("TPB System", "Board Exist", pApplicationStartOption->TPB_OperationMode);
  }
  delete iniFile;
}

